require 'g_level'
g_level.reset()


local time = 40

--INIT TEXTURES  -- adds a texture into ObjectManager<Texture>
h = FM_NEAREST;
lua_init_texture("black", "data/images/effects/black.png", FM_NEAREST, WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("credits_text", "data/images/credits.png", h, WM_REPEAT,WM_CLAMP,AM_MODULATE)

-- Create Level
lua:create_level(1.0,1.0,1.0,1.0)   --RGBA values are given also

-- Create Layers
-- The index of the layers are auto incremented. This meaning that the first one to add is 0 and rest are in order of appearance...
lua:create_layer(0.0,0.0,BM_DEFAULT)  -- x_scroll , y_scroll, blendmode  -- 0
lua:create_layer(1.0,1.0,BM_DEFAULT) -- 1
lua:create_layer(1.0,1.0,BM_DEFAULT) -- 2
lua:create_layer(0.0,0.0,BM_DEFAULT) -- 3 = dummy, for menus

-- Background starts
local scale = 1000
lua:create_sprite("black", ST_TEXTURED,"black",      0, 0) 
lua:sprite_shape("black",ST_TEXTURED,                          scale * 16.0, scale * 16.0)
lua:textured_sprite_tex_coords("black", ST_TEXTURED,           1.0, 1.0, 1.0, 1.0)
lua:sprite_color("black",                                       1.0,1.0,1.0,1.0)
g_level.upload("black",                                        0) 
-- Background ends

--credits
local scale = 1.0
lua:create_sprite("credits", ST_TEXTURED,"credits_text",         0, -1350) 
lua:sprite_shape("credits",ST_TEXTURED,                          scale * 2048.0/2, scale * 2048.0/2)
lua:textured_sprite_tex_coords("credits", ST_TEXTURED,           0.0, 0.0, 1.0, 1.0)
lua:remorfable_sprite("remo", "credits", time_to_remo_speed(time), false)             -- name, sprite_name, speed, repeat

lua:add_key_frame(1.0, 0.0, 1500.0, 0.0, 1.0)  -- adds a new key frame. time, x, y, rotation, scale
lua:add_key_frame_color(1.0,1.0,1.0,1.0)  -- r,g,b,a
lua:upload_key_frame("remo")

g_level.upload("remo",2)
lua:gameobject_remove_from_temp_list( "credits" )
--credits

--fade_in(2)
timer(time,"data/scripts/lvl_menu.lua") -- time, script

lua:set_game_state(GS_FREEZE)

